<?php

declare(strict_types=1);

use Erlage\Photogram\State;
use Erlage\Photogram\Requests\Admin\AdminAuth;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Constants\RequestConstants;
use Erlage\Photogram\Requests\Admin\AdminActions;
use Erlage\Photogram\Requests\Admin\AdminContent;
use Erlage\Photogram\Requests\Admin\AdminSettings;

/*
|--------------------------------------------------------------------------
| Handle request:
|--------------------------------------------------------------------------
*/

switch (State::getReqType())
{
    /*
    |--------------------------------------------------------------------------
    | auth requests
    |--------------------------------------------------------------------------
    */

    // auth

    case RequestConstants::REQ_TYPE_ADMIN_SESSION: AdminAuth::session();

    break;

    case RequestConstants::REQ_TYPE_ADMIN_LOGIN: AdminAuth::login();

    break;

    case RequestConstants::REQ_TYPE_ADMIN_LOGOUT: AdminAuth::logout();

    break;

    case RequestConstants::REQ_TYPE_ADMIN_UPDATE_CREDENTIALS: AdminAuth::update();

    break;

    // settings

    case RequestConstants::REQ_TYPE_ADMIN_SETTINGS_LOAD: AdminSettings::load();

    break;

    case RequestConstants::REQ_TYPE_ADMIN_SETTINGS_SAVE: AdminSettings::save();

    break;

    // contents

    case RequestConstants::REQ_TYPE_ADMIN_TABLE_STATS: AdminContent::dashboardMarkUp();

    break;

    // content

    case RequestConstants::REQ_TYPE_ADMIN_USER_SEARCH_LATEST:
        AdminContent::userSearch(ServerConstants::SERVER_CONST_LOAD_TYPE_LATEST);

    break;

    case RequestConstants::REQ_TYPE_ADMIN_USER_SEARCH_BOTTOM:
        AdminContent::userSearch(ServerConstants::SERVER_CONST_LOAD_TYPE_BOTTOM);

    break;

    case RequestConstants::REQ_TYPE_ADMIN_USER_LOAD_SINGLE: AdminContent::loadUser();

    break;

    case RequestConstants::REQ_TYPE_ADMIN_USER_SAVE_SINGLE: AdminActions::saveUser();

    break;
}
